*** COS 2018 11, Compute ICC last update 2022 11  
           
           
           
           
           
program define dq_acc_ic1  
           
syntax varlist (max=1 numeric) [if] [in], cluster(varname numeric) [regtype(int 1) ststrata(string) stcluster(string)  controlvars(string) minclustersize_icc(int 10)  indent(int 0) forcecalc(int 1)]  
marksample touse, novarlist  
           
           
           
local indent=`indent'+5  
local adoname "dq_acc_ic1"  
local text_i "di as text _n "  					  
           
           
* Retrieve pointer from global to specify scalars  
local pointer "$`varlist'"							  
local structure "`ststrata'_`stcluster'"			  
           
tempvar constvar			  
qui gen `constvar'=1	  
lab var `constvar' "Constant"  
           
if `regtype'==0 local regtypelist "re fe mle"  
if `regtype'==1 local regtypelist "fe"  
if `regtype'==2 local regtypelist "re"  
if `regtype'==3 local regtypelist "mle"  
           
           
           
tempvar clustercount		  
qui bysort `cluster': egen `clustercount' = total(`constvar')  if `touse' & `cluster' < . & `varlist'<.   	  
qui tab `cluster' if `touse' &  `cluster' < . & `varlist'<., mi  
           
tempvar sortorder  
sort `cluster' `clustercount'  
qui bysort `cluster': gen `sortorder'=_n if `touse' &  `cluster' < . & `varlist'<.  
qui count if `sortorder'==1  
scalar icc1_clall_`structure'_`pointer' = r(N)										  
           
qui sum `clustercount' if `touse' &  `sortorder'==1  
scalar icc1_min_`structure'_`pointer' 		= r(min)  
scalar icc1_max_`structure'_`pointer' 		= r(max)  
scalar icc1_mean_`structure'_`pointer'  	= trunc(r(mean))  
           
qui count if `touse' &  `sortorder'==1 & `clustercount'>`minclustersize_icc'  
local usedcluster = r(N)  
scalar icc1_clused_`structure'_`pointer' = `usedcluster'  
           
           
           
tempvar rowmiss_all  
qui egen `rowmiss_all' = rowmiss(`cluster' `varlist' `controlvars') if `touse'  
qui count if `rowmiss_all'==0  
if r(N)<`minclustersize_icc' {  
	`text_i' "Too few cases for analyses: `r(N)'"  
	scalar icc1_N_`structure'_`pointer'=r(N)  
	if `regtype'==0 | `regtype'==1 scalar icc1_re_`structure'_`pointer' =.c  
	if `regtype'==0 | `regtype'==2 scalar icc1_fe_`structure'_`pointer' =.c  
	if `regtype'==0 | `regtype'==3 scalar icc1_mle_`structure'_`pointer' =.c  
}          
           
local controlvarlist=""  
if "`controlvars'"~="" {  
	dq_hlp_cov `controlvars' if `touse' &  `clustercount'>`minclustersize_icc',  indent(`indent')  
	local controlvarlist="`r(controlvarlist)'"  
}          
 	         
           
           
* Check for existence of output, if yes and force=0 no new computation  
qui capture confirm scalar icc1_`structure'_`pointer'  
           
* if _rc>0 | `forcecalc'~=0 {	  
	          
	if `usedcluster' >1 	{	  
		foreach re_option of local regtypelist {  
			xtset `cluster'  
			if `usedcluster' >2 capture noisily xtreg `varlist' `controlvarlist' if `touse' & `clustercount'>`minclustersize_icc', `re_option'  
			if `usedcluster'==2 capture noisily xtreg `varlist' `controlvarlist' if `touse' & `clustercount'>`minclustersize_icc', `re_option'					  
			if _rc==0 {			  
				scalar icc1_N_`structure'_`pointer'=e(N)  
				local icc_cluster= e(rho)		  
				scalar icc1_`re_option'_`structure'_`pointer' =`icc_cluster'  
			}       
			        
			if _rc>0 | `=icc1_`re_option'_`structure'_`pointer''==. {		  
				`text_i' "Error encountered of value `_rc'"  
				scalar icc1_N_`structure'_`pointer'=r(N)  
				scalar icc1_`re_option'_`structure'_`pointer' =.c  
				*HOTFIX ado_strl output necessary  
			}       
			        
			xtset, clear  
		}        
	}         
* }        
           
foreach var in `controlvarlist' {  
	if strpos("`var'","___")>0 qui drop `var'  
}          
           
           
	          
end        
           
